<?php
require_once '../config/database.php';
require_once '../includes/auth_check.php';

header('Content-Type: application/json');

try {
    // Get POST data
    $input = json_decode(file_get_contents('php://input'), true);
    $supplier_id = $input['supplier_id'] ?? null;

    if (!$supplier_id) {
        throw new Exception('Supplier ID is required');
    }

    // Fetch the latest message for this supplier
    $query = "SELECT 
                sm.id,
                sm.supplier_id,
                sm.message,
                sm.amount,
                sm.type,
                sm.created_at,
                s.name as supplier_name
              FROM supplier_messages sm
              LEFT JOIN suppliers s ON sm.supplier_id = s.id
              WHERE sm.supplier_id = ?
              ORDER BY sm.created_at DESC
              LIMIT 1";

    $stmt = $pdo->prepare($query);
    $stmt->execute([$supplier_id]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $messages = [];
    foreach ($result as $row) {
        $messages[] = [
            'id' => $row['id'],
            'supplier_id' => $row['supplier_id'],
            'message' => $row['message'],
            'amount' => $row['amount'],
            'type' => $row['type'],
            'created_at' => $row['created_at'],
            'supplier_name' => $row['supplier_name']
        ];
    }

    echo json_encode([
        'success' => true,
        'messages' => $messages
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?> 